	Org	$
KbdClock	Bit	INT0
KbdData		Bit	P1.4
;DEKLARASI KONSTANTA
LShift          EQU     12H
CapsLock        EQU     58H
RShift          EQU     59H
Shift_Flag	Bit	7FH
CapsFlag	Bit	7EH


;------ Subroutine Konversi Scan Code -----
; Hasil konversi tersimpan di akumulator
; Register yang terpengaruh:
;       - DPTR

Konversi_ScanCode:
        Mov     DPTR,#TabelKeyboard     ;Isi DPTR dengan alamat awal
        Movc    A,@A+DPTR               ;TabelKeyboard
        Ret




;------ Subroutine mengambil data dari keyboard
; Register yang terpengaruh:
;       - akumulator sebagai karakter hasil konversi
;       - bit carry
; Cara kerja:
;       - apabila bit carry set maka hasil berupa karakter di akumulator
;       - apabila bit carry clear maka hasil bukan karakter
;       - apabila scan code adalah kode shift atau caps lock, maka shift
;         flag di komplemen

AmbilKeyboard:
        Lcall   Ambil_scancode          ;
	Jnc	SalahScanCode
        Cjne    A,#0F0H,Kybd_TidakLepas ;
        Jb      KbdClock,$              ;Keyboard dilepas
        Lcall   Ambil_scancode          ;
	Jnc	SalahScanCode

;PERIKSA TOMBOL YANG DILEPAS
;Periksa tombol shift atau karakter yang dilepas
;Shift atau tombol lain yang dilepas?
        Cjne    A,#LShift,Bukan_LShiftlepas     ;Shift dilepas?
        Ljmp    Komplemen_ShiftFlg              ;Ya! Komplemen Shift Flag

Bukan_LShiftlepas:
        Cjne    A,#RShift,Bukan_Shiftlepas      ;A<>RShift, bukan Shift kiri
                                                ;atau shift kanan dilepas
Komplemen_ShiftFlg:
        Cpl     Shift_Flag

Bukan_Shiftlepas:
        Clr     C
        Ret

;KEYBOARD DITEKAN
;- Periksa yang ditekan:
;       - Shift -> Komplemen Shift Flag
;       - CapsLock -> Komplemen Shift Flag
;       - Bukan Shift atau Capslock -> Konversi Scan Code
;       - Shift Flag set -> Capital
;       - Shift Flag clear -> Non Capital

Kybd_TidakLepas:
        Cjne    A,#Lshift,Bukan_Lshifttekan     ;Shift Kiri ditekan?
        Ljmp    Komplemen_ShiftFlg              ;Komplemen Shift Flag

Bukan_LShifttekan:
        Cjne    A,#RShift,Bukan_RShifttekan     ;Shift Kanan ditekan?
        Ljmp    Komplemen_ShiftFlg              ;Komplemen Shift Flag

Bukan_RShifttekan:
        Cjne    A,#CapsLock,BukanCapsLock       ;Caps Lock ditekan
	Lcall	CapsLockLED
        Ljmp    Komplemen_ShiftFlg              ;Komplemen Shift Flag
	

BukanCapsLock:
        Lcall   Konversi_Scancode               ;Konversi scan code table
        Jb      Shift_Flag,Capital              ;Shift Flag set -> capital
        Setb    C
        Ret

Capital:
        Lcall   Capitalize
        Setb    C
        Ret

Capitalize:
        Cjne    A,#'a',Periksa_Carry    ;Acc A >= 'a'?
Periksa_Carry:                          ;
        Jnc     lebih_kecil_z?          ;Ya! periksa terhadap 'z'
        Ret                             ;Tidak! Tidak ada perubahan

lebih_kecil_z?:                         ;Acc A =< 'z'?
        Cjne    A,#'z',Periksa_Carry2   ;
        Ljmp    Kapital                 ;Ya! Ubah menjadi kapital

Periksa_Carry2:
        Jc      Kapital                 ;
        Ret                             ;Tidak! Tidak ada perubahan

Kapital:
        Clr     C
        Subb    A,#20H
        Ret

SalahScanCode:
	Ret

TabelKeyboard:
        DB      00
        DB      0F9H
        DB      00
        DB      0F5H,0F3H,0F1H,0F2H,0FCH        ;Function Key, FC = F12
        DB      00H
        DB      0FAH,0F8H,0F6H,0F4H             ;FA=F10
        DB      0C0H    ;Tab    (Special Code)
        DB      '~'     ;~
        DB      00H
        DB      00H
        DB      0C1H    ;AltL   (Special Code)
        DB      0C2H    ;ShiftL (Special Code)
        DB      00H
        DB      0C3H    ;CtrlL  (Special Code
        DB      'q1'
        DB      00H,00H,00H
        DB      'zsaw2'
        DB      00H,00H
        DB      'cxde43'
        DB      00H,00H
        DB      ' vftr5'
        DB      00H,00H
        DB      'nbhgy6'
        DB      00H,00H,00H
        DB      'mju78'
        DB      00H,00H
        DB      ',kio09'
        DB      00H,00H
        DB      './l;p-'
        DB      00H,00H,00H
        DB      2CH             ; '
        DB      00H
        DB      '[='
        DB      00H,00H
        DB      0C5H
        DB      0C6H
        DB      0AH             ;Enter
        DB      ']'
        DB      00H
        DB      '\'
        DB      00H,00H,00H,00H,00H,00H,00H,00H
        DB      08H             ;BackSpace
        DB      00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H
        DB      0DH             ;Esc
        DB      00H
        DB      0FBH            ;Function Key F11
        DB      00H,04H,00H,00H,05H,00H,00H,00H,00H,00H
        DB      0F7H            ;Function Key
