$MOD51
	DSEG
CharCounter:	Ds	1
StackTemp:	Ds	1

	Org	50H
	CSEG

Delay_100mS			EQU	00A2H             
;Menunda waktu selama 100 mS (timer 0 digunakan)

Delay_500mS			EQU	0099H             
;Menunda waktu selama 500 mS (timer 0 digunakan)


;=============
;HD44780
;=============
GeserDisplay_Kanan		EQU	05BDH             
;Menggeser tampilan LCD HD44780 ke kanan

GeserDisplay_Kiri		EQU	05C4H             
;Menggeser tampilan LCD HD44780 ke kiri

Posisi_Awal			EQU	05CBH             
;Mengatur posisi cursor LCD ke posisi awal

GeserCursor_Kiri		EQU	05D2H             
;Menggeser Cursor LCD ke kiri

GeserCursor_Kanan		EQU	05D9H             
;Menggeser Cursor LCD ke kanan

KirimPesan_LCD			EQU	05E0H             
;Mengirim data di alamat yang ditunjuk oleh DPTR ke LCD hingga data 0F
;- DPTR diisi dengan alamat awal data yang dikirim
;- Akhir data adalah 0FH

Init_LCD			EQU	05ECH             
;Inisialisasi LCD

Kirim_Perintah			EQU	062BH             
;Mengirim data ke register perintah LCD
;- Data diisi di akumulator

Kirim_Karakter			EQU	064AH             
;Mengirim data ke register data LCD
;- Data diisi di akumulator

Baris2				EQU	0654H             
;Memindah posisi cursor ke baris 2

Ambil_ScanCode			EQU	0865H
;Mengambil 1 byte scan code keyboard
;- Nilai scan code berada pada akumulator

KirimScanCode			EQU	08A3H
;Mengirim 1 byte scan code keyboard
;- Nilai scan code berada pada akumulator

InitKeyboard			EQU	08C4H
;Inisialisasi Keyboard

CapslockLED				EQU	08DDH
;Mengaktifkan LED Caps Lock Keyboard

ROM			EQU	2000H
STB     Bit     INT1

	Org	ROM			;Reset Vector
	Ajmp	Start			;
	Org	ROM+3H			;External Interrupt 0 Vector
	Ljmp	Intr0
	Org	ROM+0BH			;Timer 0 Interrupt Vector
	Reti				;
	Org	ROM+13H			;External Interrupt 1 Vector
	Reti				;
	Org	ROM+1BH			;Timer 1 Interrupt Vector
	Reti				;
	Org	ROM+23H			;Serial Interrupt Vector
	Reti				;
Start:
	Lcall	Init_LCD			;Inisial LCD
	Lcall	InitKeyboard			;
        Lcall   InitPPI
	Setb	EA				;
	Setb	EX0				;
	Mov	CharCounter,#00			;
	Mov	StackTemp,SP
Loop:
	Mov	DPTR,#TabelKeypad		;Akses Keypad
	Lcall	Ambil_keypad			;
	Setb	EX0
InputDiperoleh:
	Mov	A,Nilai				;Hasil dari penekanan keypad
						;tersimpan di variabel nilai
        Push    ACC
	Lcall	Kirim_Karakter			;Kirim hasil ke LCD
        Pop     ACC
        Lcall   Kirim_Printer
	Inc	CharCounter			;Char Counter + 1
	Mov	R7,CharCounter			;
	Cjne	R7,#16,Cek32			;Char Counter = 16, pindah
	Lcall	Baris2				;ke baris 2 LCD
	Ajmp	Loop				;

Cek32:
	Cjne	R7,#32,Loop			;Char Counter = 32, kembali
	Clr	EX0
	Ajmp	Start				;ke baris 1

Kirim_Printer:
        Mov     DPTR,#4000H
        Movx    @DPTR,A
        Clr     STB
        Nop
        Setb    STB
        Ret

Intr0:
	Clr	EX0
	Push	ACC
	Push	07H
	Lcall	AmbilKarakterKeyboard
	Pop	07H
	
	Mov	Nilai,A
	Lcall	Delay_100mS
	Lcall	Delay_100mS
	Pop	ACC

	Mov	A,SP
	Mov	B,StackTemp
	Clr	C
	Subb	A,B
LoopRecoverStack:
	Pop	B
        Djnz    ACC,LoopRecoverStack

	Mov	DPTR,#Inputdiperoleh
	Push	DPL
	Push	DPH
	Setb	EX0
	Reti

AmbilKarakterKeyboard:
        Push    DPH
        Push    DPL

LoopAmbilKarakterKbd:
        Mov     DPTR,#AmbilKarakterSelesai
        Jb      INT0,$
        Lcall   AmbilKeyboard
AmbilKarakterSelesai:
        Jnc     LoopAmbilKarakterKbd
        Pop     DPL
        Pop     DPH
	Ret

InitPPI:
        Mov     DPTR,#4003H
        Mov     A,#80H
        Movx    @DPTR,A
        Ret


        $include (keypad2.asm)
        $include (kboard2.asm)
TabelKodeTombol:
	DB	' 0',0
	Org	TabelKodeTombol+10
	DB	'.,?!-&1',0
	Org	TabelKodeTombol+20
	DB	'ABC2',0
	Org	TabelKodeTombol+30
	DB	'DEF3',0
	Org	TabelKodeTombol+40
	DB	'GHI4',0
	Org	TabelKodeTombol+50
	DB	'JKL5',0
	Org	TabelKodeTombol+60
	DB	'MNO6',0
	Org	TabelKodeTombol+70
	DB	'PQRS7',0
	Org	TabelKodeTombol+80
	DB	'TUV8',0
	Org	TabelKodeTombol+90
	DB	'WXYZ9',0
	Org	TabelKodeTombol+110
	DB	'#',0
	Org	TabelKodeTombol+120
	DB	'*',0

        $include (tabkey.asm)
	END
