        CSEG
        Org     $
;---------- Cari Perintah 1 byte ---------
; Subroutine ini berfungsi untuk menjalankan program tertentu sesuai dari
; 1 byte perintah yang diterima
;
; Hasil dari subroutine ini:
;	- DPTR yang berisi alamat program yang harus dieksekusi bila carry
;	  flag clear
;	- Carry Flag Set bila perintah tidak terdapat dalam tabel
;
; DPTR diisi alamat Tabel Perintah
; Formasi Tabel Perintah:
;	DB	Perintah 1
;	DW	Label 1 lokasi program yang dieksekusi
;
;	DB	Perintah 2
;	DW	Label 2 lokasi program yang dieksekusi
;
;	DB	0
; 
; CONTOH
; TabelPerintah:
;	DB	'A'
;	DW	KarakterA
;
;	DB	'B'
;	DW	KarakterB
;	DB	AkhirtabelPerintah
;
;KarakterA:
; 	........
;	........
;KarakterB:
;	........
;	........
;
;Contoh Penggunaan:
;Start:
;	Mov	B,#'A'			;Isi B dengan perintah 'A' 
;	Mov	DPTR,#TabelPerintah	;DPTR menuju ke tabel perintah
;	Acall	CariPerintah1B		;Jalankan subrutin ini
;	Jc	Start			;Bila tidak ditemukan maka looping
;					;lagi ke label start
;	Jmp	@A+DPTR			;Bila ditemukan maka langsung ke 
;					;label yang dieksekusi

CariPerintah1B:
LoopCariPerintah:
	Mov	A,#00H
	Movc	A,@A+DPTR
	Jz	PerintahTidakKetemu
	Clr	C
	Subb	A,B
	Jz	PerintahKetemu
	Inc	DPTR
	Inc	DPTR
	Inc	DPTR
	Ljmp	LoopCariPerintah

PerintahTidakKetemu:
	Setb	C
	Ret

PerintahKetemu:
	Inc	DPTR
	Mov	A,#00H
	Movc	A,@A+DPTR
	Inc	DPTR
        Push    ACC
	Mov	A,#00H
	Movc	A,@A+DPTR
	Mov	DPH,A
	Pop	DPL
	Mov	A,#00H
	Clr	C
	Ret
