$MOD51
;*********
; TEMPLATE PEMBUATAN PROGRAM DST-52 DENGAN ASM51
 DSEG
 Org 60H
;RAM Internal yang digunakan DST-52
;30H - 38H digunakan oleh Program Monitor DDT-52 namun tetap dapat digunakan
;pada program aplikasi anda. 
;39H digunakan oleh variabel delay, bebas digunakan bila rutin2 delay tidak 
;dipanggil
;3AH dan 3BH digunakan oleh variabel Serial EEPROM, bebas digunakan bila rutin2
;Serial EEPROM tidak dipanggil
;3CH - 4CH digunakan oleh Program Monitor DDT-52 namun tetap bebas anda gunakan
;selama proses trace dan breakpoint tidak dilakukan
;4DH - 4EH digunakan oleh LCD Grafik, namun bebas digunakan selama rutin-rutin
;LCD Grafik tidak dipanggil
;50H - 5FH digunakan oleh Program Monitor DDT-52 namun tetap dapat digunakan
;pada program aplikasi anda


 CSEG


Hex_ASCII2   EQU 002EH             
;Konversi Hexa ke 2 byte ASCII
;- Akumulator diisi bilangan hexa yang akan dikonversi
;Hasil:
;- Akumulator menyimpan nibble atas
;- Register B menyimpan nibble bawah

Hex_ASCII1   EQU 003AH             
;Konversi Hexa ke 1 byte ASCII
;- Akumulator diisi bilangan hexa yang akan dikonversi
;Hasil:
;- Akumulator  menyimpan nibble bawah

ASCII_HEX   EQU 0047H             
;Konversi 2 byte ASCII ke hexa
;- Akumulator diisi nibble atas
;- Register B diisi nibble bawah
;Hasil:
;- Akumulator menyimpan hasil konversi

Dec_DPTR   EQU 0064H             
;Mengurangi isi dari Register DPTR

Capitalize   EQU 0070H             
;Mengubah semua jenis huruf kecil menjadi huruf besar

SPACE_CODE   EQU 0082H             
;Mengirim kode spasi ke port serial

Writeext_Memory   EQU 008BH             
;Menulis data ke memori EEPROM
;- Akumulator berisi data yang akan ditulis
;- DPTR berisi alamat dari data yang akan ditulis

Delay_1detik   EQU 0090H             
;Menunda waktu selama 1 detik (timer 0 digunakan)

Delay_500mS   EQU 0099H             
;Menunda waktu selama 500 mS (timer 0 digunakan)

Delay_100mS   EQU 00A2H             
;Menunda waktu selama 100 mS (timer 0 digunakan)

Delay_75mS   EQU 00ABH             
;Menunda waktu selama 75 mS (timer 0 digunakan)

Delay_5mS   EQU 00B4H             
;Menunda waktu selama 5 mS (timer 0 digunakan)

ASCII_Out   EQU 00CBH             
;Mengirim data ke port serial dalam 2 byte ASCII
;- Akumulator diisi dengan data yang akan dikirim

Out_DPTR   EQU 00D4H             
;Mengirim nilai DPTR dalam bentuk 4 byte ASCII ke port serial

Enter_Code   EQU 00DFH             
;Mengirim kode <CR> ke port serial

Init_Serial   EQU 00ECH             
;Inisialisasi Port Serial 9600 bps

Serial_Out   EQU 00FCH             
;Kirim nilai akumulator ke port serial

Serial_In   EQU 0104H             
;Ambil data dari port serial dan simpan di akumulator

KirimPesan_Serial  EQU 010CH             
;Kirim data di alamat yang ditunjuk oleh DPTR hingga data 0F
;- DPTR diisi dengan alamat dari data yang akan dikirim
;- Memori yang diakses adalah memori CODE/PROGRAM

Filter    EQU 0118H             
;Menentukan besaran data apakah berada di dalam atau di luar nilai setpoint
;- R7 diisi nilai max
;- R6 diisi nilai min
;- besaran data di akumulator
;Hasil:
;- Carry flag akan set bila besaran berada di luar nilai setpoint

;===================
; SERIAL EEPROM
;===================
Tulis_SEE16b   EQU 01A0H              
;Menulis data ke Serial EEPROM 16 bit
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- R6 diisi Word Address 2
;- Variabel DataSEE diisi data yang akan ditulis

Tulis_SEE8b   EQU 01B7H             
;Menulis data ke Serial EEPROM 8 bit
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- Variabel DataSEE diisi data yang akan ditulis

Baca_SEE16b   EQU 01CEH             
;Membaca data ke Serial EEPROM 16 bit
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- Akumulator berisi data yang telah dibaca

Baca_SEE8b   EQU 01E5H             
;Membaca data ke Serial EEPROM 8 bit
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- Akumulator berisi data yang telah dibaca

DPTRSEE8bit   EQU 02E3H
;Membaca data dari Serial EEPROM 8 bit
;- DPTR sebagai pointer
;- Akumulator berisi data yang telah dibaca

DPTRSEE16bit   EQU 02E8H
;Membaca data dari Serial EEPROM 16 bit
;- DPTR sebagai pointer
;- Akumulator berisi data yang telah dibaca

PageSEE8bWrite   EQU 027CH             
;Menulis data ke Serial EEPROM 8 bit secara page mode (Flag F0 digunakan)
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- Akumulator diisi data yang akan ditulis

PageSEE16bWrite   EQU 0285H             
;Menulis data ke Serial EEPROM 16 bit secara page mode (Flag F0 digunakan)
;- R7 diisi Device Address
;- Register B diisi Word Address 1 
;- Akumulator diisi data yang akan ditulis

TulisDPTRSEE8b   EQU 02F2H             
;Menulis data ke Serial EEPROM dengan menggunakan DPTR sebagai pointer
;- DPTR diisi alamat yang akan ditulis
;- Variabel DataSEE diisi data yang akan ditulis

TulisDPTRSEE16b   EQU 02F7H             
;Menulis data ke Serial EEPROM dengan menggunakan DPTR sebagai pointer
;- DPTR diisi alamat yang akan ditulis
;- Variabel DataSEE diisi data yang akan ditulis

DataSEE  EQU 3AH

Perbandingan16bit  EQU 0396H             
;Membandingkan data 16 bit
; DPTR = PTR, A = 0
; DPTR < PTR, C = 1
; DPTR > PTR, C = 0
;Untuk Built In Routine
; PTR+1 = 3EH
; PTR = 3FH 

;=============
;HD44780
;=============
GeserDisplay_Kanan  EQU 05BDH             
;Menggeser tampilan LCD HD44780 ke kanan

GeserDisplay_Kiri  EQU 05C4H             
;Menggeser tampilan LCD HD44780 ke kiri

Posisi_Awal   EQU 05CBH             
;Mengatur posisi cursor LCD ke posisi awal

GeserCursor_Kiri  EQU 05D2H             
;Menggeser Cursor LCD ke kiri

GeserCursor_Kanan  EQU 05D9H             
;Menggeser Cursor LCD ke kanan

KirimPesan_LCD   EQU 05E0H             
;Mengirim data di alamat yang ditunjuk oleh DPTR ke LCD hingga data 0F
;- DPTR diisi dengan alamat awal data yang dikirim
;- Akhir data adalah 0FH

Init_LCD   EQU 05ECH             
;Inisialisasi LCD

Kirim_Perintah   EQU 062BH             
;Mengirim data ke register perintah LCD
;- Data diisi di akumulator

Kirim_Karakter   EQU 064AH             
;Mengirim data ke register data LCD
;- Data diisi di akumulator

Baris2    EQU 0654H             
;Memindah posisi cursor ke baris 2

;========== LCD GRAFIK =========
InitLCDGRP   EQU 0678H             
;Inisialisasi LCD Grafik

SetTextHome   EQU 06B7H             
;Mengatur posisi awal teks
;- Akumulator diisi nibble tinggi alamat memori text
;- Register B diisi nibble rendah alamat memori text

SetGrafikHome   EQU 06BDH             
;Mengatur posisi awal tampilan grafik
;- Akumulator diisi nibble tinggi alamat memori grafik
;- Register B diisi nibble rendah alamat memori grafik

SetGrafikArea   EQU 06C3H             
;Mengatur area tampilan Grafik
;- Akumulator diisi baris dari LCD grafik
;- Register B diisi kolom dari LCD Grafik

SetTextArea   EQU 06C9H             
;Mengatur area tampilan Text
;- Akumulator diisi jumlah baris text
;- Register B diisi jumlah kolom text

TextON    EQU 06DBH             
;Mengaktifkan tampilan teks

GrafikON   EQU 06E4H             
;Mengaktifkan tampilan grafik

CursorONBlinkON   EQU 06EDH             
;Mengaktifkan Cursor dan blinking

CursorONBlinkOFF  EQU 0710H             
;Mengaktifkan cursor dan no blink

TextOFF    EQU 071AH             
;Menonaktifkan teks

GrafikOFF   EQU 0724H             
;Menonaktifkan grafik

TulisDataLCD   EQU 072EH             
;Menulis data ke memori LCD grafik
;- Register B diisi nibble tinggi dari alamat memori LCD
;- Akumulator diisi nibble rendah dari alamat memori LCD
;- Panggil subroutine SetPointerAlamat
;- R7 diisi data yang akan ditulis

BacaDataLCD   EQU 0742H             
;Membaca data dari memori LCD Grafik
;- Register B diisi nibble tinggi dari alamat memori LCD
;- Akumulator diisi nibble rendah dari alamat memori LCD
;- Panggil subroutine SetPointerAlamat

KirimPerintah   EQU 0752H             
;Mengirim data ke register perintah dari LCD Grafik
;==== DATA-DATA PERINTAH ======
TXHOME          EQU   40H
TXAREA          EQU   41H
GRHOME          EQU   42H
GRAREA          EQU   43H
SETCURSOR       EQU   21H
OFFSET          EQU   22H
ADPSET          EQU   24H
AWRON           EQU   0B0H
AWROFF          EQU   0B2H
ARON            EQU   0B1H
AROFF           EQU   AWROFF


TungguStatus1   EQU 077AH             
;Menunggu status penulisan data ke LCD grafik selesai

TungguStatusAWR   EQU 0790H             
;Menunggu status penulisan data secara otomatis ke LCD Grafik selesai

TungguStatusAR   EQU 07A6H             
;Menunggu status membaca data secara otomatis ke LCD Grafik selesai

SetPolaCursor   EQU 07BCH             
;Mengatur pola cursor LCD
Cursor1Line     EQU   0A0H
Cursor2Line     EQU   0A1H
Cursor3Line     EQU   0A2H
Cursor4Line     EQU   0A3H
Cursor5Line     EQU   0A5H
Cursor6Line     EQU   0A6H
Cursor7Line     EQU   0A7H

SetPosisiCursor   EQU 07C6H             
;Mengatur posisi cursor LCD
;- Register B diisi baris
;- Akumulator diisi kolom

SetPointerAlamat  EQU 07CFH             
;- Register B diisi alamat nibble tinggi
;- Akumulator diisi alamat nibble rendah

HapusMemori   EQU 07D8H       
;Menghapus memori teks dan memori grafik

CommandKarakter   EQU 41H
; Konstanta Command Karakter di RAM Internal alamat 4FH

KirimKarakterLCD  EQU 80AH             
;Mengirim karakter ke LCD Grafik
;- R7 diisi data karakter
;- Akumulator diisi alamat nibble tinggi
;- Register B diisi alamat nibble rendah
;- Panggil subroutine set pointer alamat
;- Tulis CommandKarakter dengan data

TulisADPplus    EQU   0C0H
BacaADPplus     EQU   0C1H
TulisADPminus   EQU   0C2H
BacaADPminus    EQU   0C3H
TulisADP        EQU   0C4H
BacaADP         EQU   0C5H

CMDP            EQU   8200H
DP              EQU   8000H

KirimPesanLCD   EQU 0817H             
;Mengirim data di alamat yang ditunjuk oleh DPTR ke LCD hingga data 0F
;- DPTR diisi dengan alamat awal data yang dikirim
;- Akhir data adalah 0FH
;- Data di memori data (sinyal RD)

BacaMemoriLCD   EQU 0831H             
;Membaca data dari memori LCD dengan DPTR sebagai pointer
;- DPTR sebagai pointer alamat
;- Data yang dibaca disimpan di akumulator

TulisMemoriLCD   EQU 084BH             
;Menulis data dari memori LCD dengan DPTR sebagai pointer
;- DPTR sebagai pointer alamat
;- Akumulator sebagai data yang akan ditulis

SWIINT          EQU 0F41H

ROM     EQU 2000H