$MOD51
;******************************************************************************
;*       PROGRAM PENGENDALI PERALATAN RUMAH TANGGA MELALUI JALUR TELEPHONE                            
;*
;* Disain oleh:
;*       Paulus Andi Nalwan, ST
;*       electronic@sby.centrin.net.id
;*
;*       DELTA ELECTRONIC
;*       Kompleks Ruko Manyar Megah Indah Plaza D-22
;*       Ngagel Jaya Selatan
;*       Surabaya 60284
;*       Phone/fax: 62-31-5020210
;*       http://www.delta-electronic.com
;******************************************************************************
        CSEG
;-------------
;Deklarasi I/O
;-------------
Gagang			Bit	T0		;Detektor Gagang telephone
						;dan ring
InterupsiDTMF		Bit	INT0		;Detektor interupsi DTMF
SettingRing	EQU	2

;-------------
;Konstanta yang digunakan
;-------------
BanyakPulsa_Ring	EQU	-40		;Jumlah sinyal dalam 1x ring
Alamat_DF88	EQU	8000H			;Alamat Modul DF88
        $include (equdst52.asm)

        DSEG
RingCounter:     Ds      1
TF1Counter:      Ds      1
        CSEG

	Org	ROM			;Reset Vector
	Ajmp	Start			;
	Org	ROM+3H			;External Interrupt 0 Vector
        Ajmp    Intr0
	Org	ROM+0BH			;Timer 0 Interrupt Vector
	Ajmp	Ring
	Org	ROM+13H			;External Interrupt 1 Vector
	Reti				;
	Org	ROM+1BH			;Timer 1 Interrupt Vector
	Ajmp	Timer1Interrupt
	Org	ROM+23H			;Serial Interrupt Vector
	Reti				;

Start:
	Acall	Init_Ring		;Inisial Software untuk Ring Detektor
	Mov	DPTR,#Alamat_DF88	;Reset MT8888
	Lcall	Init_Mt8888		;

	Lcall	Init_LCD
        Ajmp    $


Init_Ring:
	Clr	TR1
	Mov	RingCounter,#0
	Clr	TF0				;Hapus Flag Timer 0
	Mov	TMOD,#15H			;Timer 0 Mode 16 bit counter
	Lcall	Reset_Counter0			;Set Counter 0 -40
	Acall	ResetCounter1
	Mov	TF1Counter,#00
	Setb	TR0				;Start Timer 0
	Setb	ET0				;Aktifkan Timer 0 Interrupt
	Setb	ET1
	Setb	EA				;Aktifkan interupsi semua
	Ret

Reset_Counter0:
	Mov	TH0,#0FFH
	Mov	TL0,#BanyakPulsa_Ring
	Ret

;***** Subroutine untuk menampilkan pesan 'ring' di LCD setiap ring terjadi ***
; - Ring pertama akan mengaktifkan timer time out
; - Ring berikutnya akan mereset timer time out
; - bila time out, maka panggilan batal
; - Bila sesudah jumlah setting maka koneksi terjadi

Ring:
	Clr	EA				;Matikan Seluruh interupsi
	Clr	ET0				;
	Clr	TR0				;Matikan Counter 0
        Push    Acc
	Inc	RingCounter
	Mov	A,RingCounter
	Cjne	A,#01H,BukanRingPertama
        Pop     Acc 
	Setb	TR1

LoopRing:
	Push	DPH				;Simpan DPTR di Stack
	Push	DPL				;
	Mov	DPTR,#Pesan_Ring		;Tampilkan Pesan Ring
	Lcall	KirimPesan_LCD			;
	Lcall	Delay_1detik
	Lcall	Reset_Counter0			;
	Clr	TF0
	Pop	DPL				;Ambil DPTR dari Stack
	Pop	DPH				;
	Setb	TR0				;Aktifkan Counter 0
	Setb	ET0				;Aktifkan interupsi counter 0
	Setb	EA				;Aktifkan Seluruh Interrupt
	Setb	EX0
	Setb	C
	Reti

BukanRingPertama:
	Cjne	A,#SettingRing,BelumConnect
        Pop     ACC
	Mov	RingCounter,#00H
	Clr	T1				;Aktifkan relay Off Hook

;====== hubungan telah terjadi ========

	Mov	DPTR,#PesanConnect
	Lcall	Init_LCD
	Lcall	KirimPesan_LCD
	Clr	EA
	Clr	ET0
	Clr	ET1

LoopNomorAlat:
	Acall	AmbilDTMF			;Ambil nomor alat yang diakses
	Cjne	A,#0Ch,lanjutkan			;Bukan '#' tidak dibatalkan
	Setb	T1			;On Hook
	Mov	SP,#07H
	Mov	DPTR,#Start
	Push	DPL
	Push	DPH
	Reti

Lanjutkan:	
	Mov	B,A 
	Mov	DPTR,#TabelPerintah	;DPTR menuju ke tabel perintah
	Acall	CariPerintah1B		;Jalankan subrutin ini
	Jc	LoopNomorAlat		;Bila tidak ditemukan maka looping
					;lagi ke label start
	Jmp	@A+DPTR			;Bila ditemukan maka langsung ke 

BelumConnect:
        Pop     ACC
	Acall	ResetCounter1
	Mov	TF1Counter,#00	
	Ajmp	LoopRing

ResetCounter1:
	Mov	TH1,#00
	Mov	TL1,#00
	Ret



;============== EKSEKUSI PERINTAH ==============
PerintahON	EQU	01
PerintahOFF	EQU	00

;DEV 1
AksesDev1:
	Jb	P1.0,TidakAktif1
	Acall	TonePendek

TungguPerintah1:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON1
	Clr	P1.0
	Ajmp	LoopNomorAlat

BukanOn1:
	Cjne	A,#PerintahOFF,TungguPerintah1	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.0
	Ajmp	LoopNomorAlat

TidakAktif1:
	Acall	TonePanjang
	Ajmp	TungguPerintah1

;DEV 2
AksesDev2:
	Jb	P1.1,TidakAktif2
	Acall	TonePendek

TungguPerintah2:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON2
	Clr	P1.1
	Ajmp	LoopNomorAlat

BukanOn2:
	Cjne	A,#PerintahOFF,TungguPerintah2	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.1
	Ajmp	LoopNomorAlat

TidakAktif2:
	Acall	TonePanjang
	Ajmp	TungguPerintah2

;DEV 3
AksesDev3:
	Jb	P1.2,TidakAktif3
	Acall	TonePendek

TungguPerintah3:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON3
	Clr	P1.2
	Ajmp	LoopNomorAlat

BukanOn3:
	Cjne	A,#PerintahOFF,TungguPerintah3	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.2
	Ajmp	LoopNomorAlat

TidakAktif3:
	Acall	TonePanjang
	Ajmp	TungguPerintah3

;DEV 4
AksesDev4:
	Jb	P1.3,TidakAktif4
	Acall	TonePendek

TungguPerintah4:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON4
	Clr	P1.3
	Ajmp	LoopNomorAlat

BukanOn4:
	Cjne	A,#PerintahOFF,TungguPerintah4	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.3
	Ajmp	LoopNomorAlat

TidakAktif4:
	Acall	TonePanjang
	Ajmp	TungguPerintah4

;DEV 5
AksesDev5:
	Jb	P1.4,TidakAktif5
	Acall	TonePendek

TungguPerintah5:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON5
	Clr	P1.4
	Ajmp	LoopNomorAlat

BukanOn5:
	Cjne	A,#PerintahOFF,TungguPerintah5	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.4
	Ajmp	LoopNomorAlat

TidakAktif5:
	Acall	TonePanjang
	Ajmp	TungguPerintah5

;DEV 6
AksesDev6:
	Jb	P1.5,TidakAktif6
	Acall	TonePendek

TungguPerintah6:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON6
	Clr	P1.5
	Ajmp	LoopNomorAlat

BukanOn6:
	Cjne	A,#PerintahOFF,TungguPerintah6	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.5
	Ajmp	LoopNomorAlat

TidakAktif6:
	Acall	TonePanjang
	Ajmp	TungguPerintah6

;DEV 7
AksesDev7:
	Jb	P1.6,TidakAktif7
	Acall	TonePendek

TungguPerintah7:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON7
	Clr	P1.6
	Ajmp	LoopNomorAlat

BukanOn7:
	Cjne	A,#PerintahOFF,TungguPerintah7	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.6
	Ajmp	LoopNomorAlat

TidakAktif7:
	Acall	TonePanjang
	Ajmp	TungguPerintah7

;DEV 8
AksesDev8:
	Jb	P1.7,TidakAktif8
	Acall	TonePendek

TungguPerintah8:
	Acall	AmbilDTMF
	Cjne	A,#PerintahON,BukanON8
	Clr	P1.7
	Ajmp	LoopNomorAlat

BukanOn8:
	Cjne	A,#PerintahOFF,TungguPerintah8	;Bukan OFF, berarti bukan ON maupun OFF
	Setb	P1.7
	Ajmp	LoopNomorAlat

TidakAktif8:
	Acall	TonePanjang
	Ajmp	TungguPerintah8


;=============== TIME OUT RING =============
Timer1Interrupt:
	Clr	EX0
	Clr	ET1
	Clr	TR1
	
	Mov	TH1,#00
	Mov	TL1,#00
        Push    Acc
	Inc	TF1Counter
	Mov	A,TF1Counter
	Cjne	A,#200,BelumTimeOut
	Mov	TF1Counter,#00		;Reset Counter Ring
	Mov	RingCounter,#00		;
        Pop     Acc
	Setb	TR1
	Setb	ET1
	Setb	EX0
	Reti


BelumTimeOut:
        Pop     Acc
	Setb	TR1
	Setb	ET1
	Setb	EX0
	Reti	

;============================

Pesan_Ring:
	DB	'Ring',0FH

INTR0:
	Push	DPH				;Simpan register2 yg digunakan
	Push	DPL				;dalam rutin ini ke stack
        Push    ACC                               ;
	Clr	EX0				;Matikan Interupsi 0
	Lcall	Baris2				;Cursor pindah ke baris 2
LoopDTMF:
	Mov	DPTR,#Alamat_DF88		;Ambil Data DTMF dari register
	Movx	A,@DPTR				;data MT8888
	Anl	A,#0FH				;
	Cjne	A,#10,BukanNol			;Konversi 10 ke nol
	Clr	A				;
BukanNol:
	Add	A,#30H				;Ubah ke ASCII Numerik
	Lcall	Kirim_Karakter			;Kirim ke LCD
	Mov	DPTR,#Alamat_DF88+100H		;

;---------
;Bagian ini berfungsi untuk menunggu sinyal DTMF hilang sambil memeriksa
;kondisi Hook
TungguDTMF:
	Movx	A,@DPTR				
	Jb	Gagang,ONHook			;Bila ON Hook, lompat ke 
						;label ONHook
        Jnb     Acc3,TungguDTMF           
	Mov	DPTR,#Alamat_DF88+100H		
;---------
;Bagian ini berfungsi untuk menunggu interupsi MT8888 non aktif sambil
;memeriksa kondisi Hook
TungguIRQ:
	Movx	A,@DPTR
	Jb	Gagang,ONHook
        Jnb     Acc0,TungguIRQ
	Jnb	INT0,TungguIRQ
;----------
	Jnb	Gagang,LoopDTMF		;Periksa kondisi hook
ONHook:
	Lcall	Init_LCD		;ON Hook, hapus layar LCD
        Pop     Acc                       ;Ambil register-register yang disim
	Pop	DPL			;pan di stack
	Pop	DPH			;
	Setb	EX0			;Aktifkan interupsi DTMF
	Reti

Init_MT8888:
	INC   DPH
	MOVX  A,@DPTR
	CLR   A
	MOVX  @DPTR,A
	MOVX  @DPTR,A
	MOV   A,#008h
	MOVX  @DPTR,A
	CLR   A
	MOVX  @DPTR,A
	MOVX  A,@DPTR
	MOV   A,#00Dh
	MOVX  @DPTR,A
	MOV   A,#000h
	MOVX  @DPTR,A
	RET   

AmbilDTMF:
	Jb	INT0,$
	Mov	DPTR,#Alamat_DF88		;Ambil Data DTMF dari register
	Movx	A,@DPTR				;data MT8888
	Anl	A,#0FH				;
	Cjne	A,#10,TidakNol			;Konversi 10 ke nol
	Clr	A				;
TidakNol:
        Push    Acc
	Mov	DPTR,#Alamat_DF88+100H		;

;---------
;Bagian ini berfungsi untuk menunggu sinyal DTMF hilang sambil memeriksa
;kondisi Hook
WaitDTMF:
	Movx	A,@DPTR				
        Jnb     Acc3,WaitDTMF             
	Mov	DPTR,#Alamat_DF88+100H		
;---------
;Bagian ini berfungsi untuk menunggu interupsi MT8888 non aktif sambil
;memeriksa kondisi Hook
IRQDTMF:
	Movx	A,@DPTR
	Jnb	INT0,IRQDTMF
        Pop     Acc
	Ret


TonePanjang:
	Lcall	Delay_500mS
	Mov	DPTR,#Alamat_DF88+100h
	Mov	A,#0Dh
	Movx	@DPTR,A
	Mov	A,#01H
	Movx	@DPTR,A
	Lcall	Delay_1detik
	Mov	A,#0Dh
	Movx	@DPTR,A
	Mov	A,#00H
	Movx	@DPTR,A
	Ret

TonePendek:
	Lcall	Delay_500mS
	Mov	DPTR,#Alamat_DF88+100h
	Mov	A,#0Dh
	Movx	@DPTR,A
	Mov	A,#01H
	Movx	@DPTR,A
	Lcall	Delay_100mS
	Lcall	Delay_100mS
	Mov	A,#0Dh
	Movx	@DPTR,A
	Mov	A,#00H
	Movx	@DPTR,A
	Ret

TabelPerintah:
	DB	1
	DW	AksesDev1
	DB	2
	DW	AksesDev2
	DB	3
	DW	AksesDev3
	DB	4
	DW	AksesDev4
	DB	5
	DW	AksesDev5
	DB	6
	DW	AksesDev6
	DB	7
	DW	AksesDev7
	DB	8
	DW	AksesDev8
	DB	0

PesanTimeOut:
	DB	'Time Out',0Fh

PesanConnect:
	DB	'Connect',0Fh

        $include (cariprnt.asm)
        end
