$MOD51        
        DSEG
	Org	50H
TabelDesimal:    Ds      3
SetPointMax:     Ds      1
SetPointMin:     Ds      1
SetPoint:        Ds      1
WaktuSampling:   Ds      1
Suhu0:           Ds      1

Toleransi       EQU     3


        CSEG


;HD44780 

Posisi_Awal			EQU	05CBH             
;Mengatur posisi cursor LCD ke posisi awal


KirimPesan_LCD			EQU	05E0H             
;Mengirim data di alamat yang ditunjuk oleh DPTR ke LCD hingga data 0F
;- DPTR diisi dengan alamat awal data yang dikirim
;- Akhir data adalah 0FH

Init_LCD			EQU	05ECH             
;Inisialisasi LCD

Kirim_Perintah			EQU	062BH             
;Mengirim data ke register perintah LCD
;- Data diisi di akumulator

Kirim_Karakter			EQU	064AH             
;Mengirim data ke register data LCD
;- Data diisi di akumulator

Baris2				EQU	0654H             
;Memindah posisi cursor ke baris 2


Switch	Bit	T1
Sensor	Bit	T0
ADCInterrupt	Bit	INT0

AlamatADC	EQU	0C000H		;6F00H untuk SC-51

ROM			EQU	2000H

	Org	ROM			;Reset Vector
	Ajmp	Start			;
	Org	ROM+3H			;External Interrupt 0 Vector
	Reti				;
	Org	ROM+0BH			;Timer 0 Interrupt Vector
        Reti
	Org	ROM+13H			;External Interrupt 1 Vector
	Reti				;
	Org	ROM+1BH			;Timer 1 Interrupt Vector
	Ajmp	Timer1_Interrupt
	Org	ROM+23H			;Serial Interrupt Vector
	Reti				;
Start:
	Lcall	Init_LCD		;Inisial LCD

	Lcall	AturSetPoint		;Isi Set point suhu
	
	Acall	StartHeater		;Aktifkan pemanas

	Mov	DPTR,#AlamatADC
	Movx	@DPTR,A
        Jb      ADCInterrupt,$
	

Loops:

	Clr	EA			;Non aktifkan interupsi
	Lcall	Baris2			;Tampilkan pesan 'suhu =' pada layar LCD
	Mov	DPTR,#PesanSuhu		;
	Lcall	KirimPesan_LCD		;
	Setb	EA			;Aktifkan interupsi
	Acall	AmbilADC		;Ambil data ADC
	Acall	KonversiSuhu		;
	Acall	TampilNilaiSuhu		;Tampilkan nilai suhu ke LCD

	Mov	WaktuSampling,#04

DelaySampling:
	Lcall	Delay_1detik
	Djnz	WaktuSampling,DelaySampling
	Clr	TR0
	
	Acall	AdjustHeater
	Jnc	Loops
	
        Clr     EA
        Lcall   Init_LCD
        Mov     DPTR,#PesanTercapai
        Lcall   KirimPesan_LCD
        Setb    EA
        Ajmp    Loops

PesanTercapai:
        DB      'Tercapai',0FH


TampilNilaiSuhu:
        Push    ACC
	Clr	EA			;Tampilkan data di alamat ke tujuh
	Mov	A,#0C7H			;dari baris 2 LCD
	Lcall	Kirim_Perintah		;
	Mov	A,#' '			;
	Lcall	Kirim_Karakter		;
	Mov	A,#' '			;
	Lcall	Kirim_Karakter		;
	Mov	A,#' '			;
	Lcall	Kirim_Karakter		;
	Mov	A,#0C7H
	Lcall	Kirim_Perintah
	Mov	A,#TabelDesimal
	Acall	TampilkanDesimal
        Pop     ACC
	Setb	EA
	Ret

PesanAturSuhu:
	DB	'Turunkan Suhu',0FH


OutLCD:
	Lcall	Hex_ASCII2
	Push	B
	Lcall	Kirim_Karakter
        Pop     ACC
	Lcall	Kirim_Karakter
	Ret
	


TampilkanDesimal:
	Add	A,R6
	Mov	R0,A

Loop:
	Dec	R0
	Mov	A,@R0
	Add	A,#30H
	Lcall	Kirim_Karakter
	Djnz	R6,Loop
	Ret

Konversi2BDesimal:		
	Mov	R6,#00H
	Jz	Tidak2Konversi

Loop2Konversi:
	Mov	B,#10
        Push    ACC
	Subb	A,B
        Pop     ACC
	Inc	R6
	Jc	Konversi2Selesai
	Div	AB
	Mov	@R0,B
	Inc	R0
	Ajmp	Loop2Konversi

Konversi2Selesai:
	Mov	@R0,A
Tidak2Konversi:
	Ret

AmbilADC:
	Mov	DPTR,#AlamatADC		;Ambil data ADC
	Clr	A
	Movx	@DPTR,A			;
        Jb      ADCInterrupt,$          ;
	Movx	A,@DPTR
	Ret

KonversiSuhu:
	Mov	DPTR,#TabelVolt8bSuhu	;Konversi data ADC ke suhu
	Movc	A,@A+DPTR		;
        Push    ACC                       ;
	Mov	R0,#TabelDesimal	;
	Acall	Konversi2bDesimal	;
        Pop     ACC
	Ret

AturSetPoint:
	Mov	DPTR,#PesanSetPoint
	Lcall	KirimPesan_LCD
	Lcall	Ambil2digitKeypad
	Mov	SetPoint,A
        Push    ACC
	Add	A,#Toleransi
	Mov	SetpointMax,A
        Pop     ACC
	Cjne	A,#Toleransi,$+3
	Jc	TidakKurangiToleransi
        Push    ACC
	Lcall	Baris2
        Pop     ACC
	Subb	A,#Toleransi
TidakKurangiToleransi:
	Mov	SetPointMin,A
	Ret

PesanSetPoint:
	DB	'Setpoint : ',0FH

PesanSuhu:
	DB	'Suhu : ',0FH



;********************
; BAGIAN PENGATUR 
AdjustHeater:
	Mov	R7,SetPointMax		;Periksa apakah sesuai dengan setpoint
	Mov	R6,SetPointMin		;
	Acall	CekSetPoint		;
	Jnc	Sesuai			;C = 0, sesuai
	Mov	A,R7			;R7<>0FF, tambah suhu
	Cjne	A,#0FFH,TambahSuhu	;
	Dec	PWMTime			;R7=0FF, PWM-1
	Mov	A,PWMTime		;Jaga PWM tidak dibawah 1
	Jnz	BelumMin		;
	Mov	PWMTime,#01H		;
BelumMax:
BelumMin:	
	Clr	C
	Ret
Sesuai:
	Setb	C
	Ret

TambahSuhu:
	Inc	PWMTime
	Mov	A,PWMTime
	Cjne	A,#0,BelumMax
	Mov	PWMTime,#0FFH
	Ret

        $include (tabsuhu.asm)
        $include (heater.asm)
        $include (setpnt1b.asm)
        $include (ambkypd.asm)
        $include (keypad2.asm)
        $include (delay_1d.asm)
        $include (hexascii.asm)
        $include (hexdec1b.asm)
        $include (tabkey2.asm)
       
        END
