        DSEG
        Org     $
Alamat_LCD:     Ds      1
        CSEG
        Org     $
RS	Bit	P2.1
EClock	Bit	P2.7
RW	Bit	P2.6
Backlight	Bit	P1.5


KirimPesan_LCD:
LoopKirimPesan_LCD:
	Mov	A,#00H			;Ambil data dari memori yg ditunjuk
	Movc	A,@A+Dptr		;
	Cjne	A,#0FH,Kirim_LCD	;Kirim ke LCD selama belum ditemukan
	Ret				;0FH
	
Kirim_LCD:
	Acall	Kirim_Karakter
	Inc	Dptr			;Tunjuk ke memori selanjutnya
	Ajmp	LoopKirimPesan_LCD

;********* SUBROUTINE INISIAL LCD **********
Init_LCD:
	Setb	RS
	Clr	EClock
	Lcall	Delay_5mS		;Tunda 20 mS
	Lcall	Delay_5mS		;
	Lcall	Delay_5mS		;
	Lcall	Delay_5mS		;
	Mov	A,#30H			;Kirim 30H
	Acall	Kirim_Perintah		;
	Lcall	Delay_5mS		;Tunda 5mS

	Mov	A,#30H			;Kirim 30H
	Acall	Kirim_Perintah		;
	Push	B			;Tunda 100uS lebih
	Mov	B,#100			;
	Djnz	B,$			;
	Pop	B			;

	Mov	A,#30H			;
	Acall	Kirim_Perintah		;

	Mov	A,#20H			;Send Init
	Acall	Kirim_Perintah		;

	Mov	A,#28H			;8x5 2lines
	Acall	Kirim_Perintah		;
	
	Mov	A,#08H			;Display OFF
	Acall	Kirim_Perintah		;
	
	Mov	A,#01H			;Display Clear
	Acall	Kirim_Perintah		;

	Mov	A,#0EH			;Display ON
	Acall	Kirim_Perintah		;

	Mov	A,#06H			;Mode Increment Address
	Acall	Kirim_Perintah		;
	Ret

Kirim_Perintah:
	Clr	RS
	Clr	RW
	Acall	Kirim_DataLCD		;4 bit sebanyak 2 x
	Swap	A
	Acall	Kirim_DataLCD		;
	Acall	PeriksaBusy
	Ret				;

Kirim_DataLCD:
	Setb	EClock
	Mov	P0,A			;Kirim ke Port 0
	Clr	EClock
	ret

Kirim_Karakter:
	Clr	RW
	Setb	RS
	Acall	Kirim_DataLCD		;ke LCD 2x
	Swap	A
	Acall	Kirim_DataLCD		;
	Acall	PeriksaBusy
	Ret

BacaRegister:
	Mov	P0,#0FFH		;Jadikan P0 sebagai input
	Setb	RW			;LCD mode Read
	Clr	RS			;RS = 0
	Setb	EClock			;
	Mov	A,P0
	Anl	A,#0F0H
	Clr	EClock
        Push    ACC
	Setb	EClock
	Mov	A,P0
	Anl	A,#0F0H
	Clr	EClock
        Swap    A
	Pop	B
	Add	A,B
	Clr	RW
	Ret

PeriksaBusy:
	Acall	BacaRegister
        Jb      ACC7,PeriksaBusy
	Ret

;----------------------
;LCD pindah baris 2

Baris2:
	Mov	A,#BarisDua
	Acall	Kirim_Perintah
	Ret

;----------------------
;LCD pindah baris 1
Baris1:
	Mov	A,#HomeLCD
	Acall	Kirim_Perintah
	Ret

;----------------------
;Geser Display ke kanan

GeserDisplay_Kanan:
	Mov	A,#RDisplay
	Acall	Kirim_Perintah
	Ret

;----------------------
;Geser Display ke kiri

GeserDisplay_Kiri:
	Mov	A,#LDisplay
	Acall	Kirim_Perintah
	Ret


;----------------------
;Geser Cursor ke kiri

GeserCursor_Kiri:
	Mov	A,#LCursor
	Acall	Kirim_Perintah
	Ret

;----------------------
;Geser Cursor ke kanan

GeserCursor_Kanan:
	Mov	A,#RCursor
	Acall	Kirim_Perintah
	Ret

RCursor		EQU	14H
LCursor		EQU	10H
RDisplay	EQU	1FH
LDisplay	EQU	18H	
HomeLCD		EQU	02H
BarisDua	EQU	0C0H
