;***********************
; RUTIN TIMER
; - Tampilan 		: M1632 LCD
; - Input data		: Keypad 4x3
; - Satuan Timer 	: 10 mili detik
; - Bentuk tampilan	: Jam : menit : detik
;***********************

	DSEG
	Org	$
NilaiTimer:	Ds	6		;mili detik, detik, menit
StackTimer:	Ds	1		;Stack Timer Temporary
RTemp:		Ds	6		;Register Temporary

	CSEG
	Org	$
;***************
; RUTIN UNTUK MENGAKTIFKAN TIMER
;****************
StartTimer0:
	Mov	StackTimer,SP		;Simpan nilai Stack Pointer 
	Mov	A,TMOD			;Atur mode timer 0 tanpa mengubah
	Anl	A,#0F0H			;mode timer 1
	Orl	A,#01H			;
	Mov	TMOD,A			;
	Acall	ResetTimer0		;
	Setb	EA			;Aktifkan Interupsi
	Setb	ET0			;
	Setb	TR0			;Aktifkan Timer 0
	Ret

;****************
; RUTIN ISI NILAI AWAL TIMER DENGAN KEYPAD DAN TAMPILKAN DI M1632 LCD
;****************

ResetNilaiTimer:
	Mov	R0,#NilaiTimer+3		;Nilai Jam <- Keypad
	Acall	Ambil2digitKeypad		;
	Mov	@R0,A				;
	Dec	R0				;
	Mov	A,#':'				;Tampilkan :
	Lcall	Kirim_Karakter			;
	Acall	Ambil2digitKeypad		;Nilai Menit <- Keypad
	Mov	@R0,A				;
	Dec	R0				;
	Mov	A,#':'				;Tampilkan :
	Lcall	Kirim_Karakter			;
	Acall	Ambil2digitKeypad		;Nilai Detik <- Keypad
	Mov	@R0,A				;
	Dec	R0				;
	Mov	@R0,#00				;Nilai Mili detik = 00
	Ret					;

;**********************
; HARGA AWAL TIMER 0
; - Rutin memberi harga awal nilai timer 0 yang berfungsi sebagai pre scaler
;   dari timer
; - Jumlah siklus x 12/Frekwensi crystal = 10 mS
;   Jumlah siklus = 10 mS x Frekwensi crystal / 12
;   Jumlah siklus = 9216 => 2400H
; - Nilai Timer = -jumlah siklus = -2400H = DC00H

Resettimer0:
	Mov	TH0,#0DCH		;Nilai Timer diisi
	Mov	TL0,#00H
	Ret

;**********************
; RUTIN INTERUPSI TIMER 0
; - Terjadi setiap 10 ms
; - Nilai Timer berkurang setiap 10 ms
;**********************

Timer0_Interrupt:
	Acall	ResetTimer0
	Acall	KurangiWaktu
	Setb	ET0	
	Reti

;*******************
; RUTIN PENGURANGAN WAKTU DENGAN FORMASI 24 HOURS
;*******************

KurangiWaktu:
	Mov	R0,#NilaiTimer		;Mili detik - 1
	Dec	@R0			;
	Mov	A,@R0			;
	Cjne	A,#-1,TidakReset	;
	Mov	@R0,#99			;Mili detik = -1 -> Mili detik = 99
	Acall	DisplayTimer		;Tampilkan nilai timer
	Inc	R0			;Detik - 1
	Dec	@R0			;
	Mov	A,@R0			;

	Cjne	A,#-1,TidakReset	;Detik = -1 -> Detik = 59
	Mov	@R0,#59			;
	Inc	R0			;
	Dec	@R0			;Detik - 1
	Mov	A,@R0			;

	Cjne	A,#-1,TidakReset	;Menit = -1 -> Menit = 59
	Mov	@R0,#59			;
	Inc	R0			;
	Dec	@R0			;Menit - 1
	Mov	A,@R0			;
	
	Cjne	A,#-1,TidakReset	;Jam = -1 -> Time Out
	Clr	TR0			;Timer berhenti

	Mov	RTemp+5,DPH		;
	Mov	RTemp+4,DPL		;
	Mov	RTemp+3,00		;
	Mov	RTemp+2,A		;Simpan nilai-nilai register di register
	Mov	RTemp+1,B		;temporary
	Mov	RTemp,PSW		;

	Mov	B,StackTimer
	Mov	A,SP
	Clr	C
	Subb	A,B

LoopRecover:
	Pop	00H
	Djnz	ACC,LoopRecover
	Pop	00H
	Pop	00H
	Mov	DPTR,#TimerSelesai
	Push	DPL
	Push	DPH
	Mov	PSW,RTemp		;Ambil kembali nilai-nilai register
	Mov	B,RTemp+1		;dari register temporary
	Mov	A,RTemp+2		;
	Mov	00H,RTemp+3		;
	Mov	DPL,RTemp+4		;
	Mov	DPH,RTemp+5		;

TidakReset:
	Ret

;*************************************
; TAMPILKAN NILAI TIMER KE M1632 LCD
; - Nilai timer tersimpan dalam tabel desimal
; - Formasi tabel desimal adalah:
;	mili detik, detik, menit, jam
;*************************************
DisplayTimer:
	Push	ACC
	Lcall	Posisi_Awal
	Push	0H
	Push	7H
	Mov	R0,#NilaiTimer+3
	Mov	R7,#3
LoopdisplayTimer:
	Mov	A,@R0
	Acall	Konversi1bdesimal
	Mov	A,TabelDesimal+1
	Add	A,#30H
	Lcall	Kirim_Karakter
	Mov	A,TabelDesimal
	Add	A,#30H
	Lcall	Kirim_Karakter
	Dec	R0
	Djnz	R7,TampilkanTerus
	Pop	07H
	Pop	0H
	Pop	ACC
	Ret

TampilkanTerus:
	Mov	A,#':'
	Lcall	Kirim_Karakter
	Ajmp	LoopDisplayTimer
