;PROGRAM SISTEM ABSENSI SEDERHANA
;- Kapasitas 20 user
;- Waktu: 7 hari
;Menu:
;- Set Nomor kartu
;- Display record
;- Kirim record ke PC
;- Hapus record
;
;Create by: 
;Paulus Andi Nalwan, ST
;DELTA ELECTRONIC
;www.delta-electronic.com


JamDatang	EQU	08
MenitDatang	EQU	00

P13	Bit	7Eh
DefaultID	EQU	56h

       	.DATA
	Org	30H
Temp	Ds	1
Buffer	Ds	25
RAMCounterRecord	Ds	2
PointerRecord	Ds	1
UserID	Ds	2


	.CODE
	Org	00
	Ljmp	Start

	Org	03
	Reti

SetDefault:
	Mov	DataI2C,#DefaultID
	Lcall	TulisDPTRSEE8b

	Lcall	HapusRecord			;Hapus data di record
	Ljmp	SelesaiDefault


Start:
	Lcall	Init_Serial
	Mov	DPTR,#Default
	Lcall	DPTRSEE8bit
	Cjne	A,#DefaultID,SetDefault

SelesaiDefault:
	Lcall	ResetLCD
	Lcall	Init_LCD

	Lcall	Delay_1detik
	Lcall	TurnONDS1307
	Lcall	InitReader


;===== REQUEST TYPE KARTU
Loop:
	Mov	A,#83H
	Lcall	Kirim_Perintah
	Lcall	AmbilDataDS1307
	Lcall	DisplayWaktu


	Lcall	BacaKartu
	Jnc	ProsesKartu

	Lcall	AmbilDataKeypad
	Mov	DPTR,#TabelPerintah
	Lcall	CariPerintah1B
	Jc	Loop
	Jmp	@A+DPTR



ProsesKartu:

	Mov	DPTR,#AlamatRecord		;Ambil alamat record dan simpan
	Lcall	DPTRSEE8bit			;di DPTR
	Push	A				;
	Inc	DPTR				;
	Lcall	DPTRSEE8bit			;
	Pop	DPL				;
	Mov	DPH,A				;


	Mov	R0,#Buffer+6			;Ambil data ID
	Mov	DataI2C,@R0			;
	Lcall	TulisDPTRSEE8b			;
	Inc	R0				;
	Inc	DPTR				;
	Mov	DataI2C,@R0			;
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;


	Lcall	AmbilDataDS1307
	Mov	R0,#BufferDS1307
	Mov	DataI2C,@R0			;Detik
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0
	Mov	DataI2C,@R0			;Menit
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0
	Mov	DataI2C,@R0			;Jam
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0
	Inc	R0
	Mov	DataI2C,@R0			;Tanggal
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0
	Mov	DataI2C,@R0			;Bulan
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0
	Mov	DataI2C,@R0			;Tahun
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Inc	R0


	
	Push	DPH				;Simpan alamt di stack	
	Push	DPL				;
	Mov	DPTR,#AlamatRecord		;
	Pop	DataI2C
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Pop	DataI2C				;
	Lcall	TulisDPTRSEE8b			;


	Lcall	ReloadCounterRecord
	Inc	RAMCounterRecord		;Counter + 1
	Mov	A,RAMCounterRecord		;
	Jnz	NoInc2				;
	Inc	RAMCounterRecord+1		;
NoInc2:						;
	Mov	DPTR,#CounterRecord		;
	Mov	DataI2C,RAMCounterRecord	;
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Mov	DataI2C,RAMCounterRecord+1	;
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;

	Mov	A,BufferDS1307+2
	Cjne	A,#JamDatang,$+3
	Jnc	CekMenit
	Lcall	Init_LCD
	Mov	A,#82h
	Lcall	Kirim_Perintah
	Mov	A,Buffer+6			;Display ID
	Lcall	LCDOut				;
	Mov	A,Buffer+7			;
	Lcall	LCDOut				;

	Mov	DPTR,#PesanOK
	Lcall	KirimPesan_LCD
	Lcall	Delay_1detik
	Lcall	ResetLCD
	Ljmp	Loop

CekMenit:
	Mov	A,BufferDS1307+1
	Cjne	A,#MenitDatang+1,$+3
	Jnc	Terlambat
	Lcall	Init_LCD
	Mov	A,#82h
	Lcall	Kirim_Perintah

	Mov	A,Buffer+6			;Display ID
	Lcall	LCDOut				;
	Mov	A,Buffer+7			;
	Lcall	LCDOut				;

	Mov	DPTR,#PesanOK
	Lcall	KirimPesan_LCD
	Lcall	Delay_1detik
	Lcall	ResetLCD
	Ljmp	Loop

Terlambat:
	Lcall	Init_LCD
	Mov	A,#80h
	Lcall	Kirim_Perintah
	Mov	A,Buffer+6			;Display ID
	Lcall	LCDOut				;
	Mov	A,Buffer+7			;
	Lcall	LCDOut				;


	Mov	DPTR,#PesanTerlambat
	Lcall	KirimPesan_LCD
	Lcall	Delay_1detik
	Lcall	ResetLCD
	Ljmp	Loop


TabelPerintah:
	DB	'A'
	DW	IsiKartu
	DB	'B'
	DW	DisplayData
	DB	'C'
	DW	KirimDataKartu
	DB	'D'
	DW	HapusData
	DB	0


PesanNomorUser:
	DB	'NO USER: ',0Fh

PesanVerifikasi:
	DB	'VERIFIKASI: ',0Fh


HapusData:
	Lcall	ResetLCD
	Lcall	HapusRecord
	Lcall	ResetLCD
	Ljmp	Loop

IsiKartu:
	Lcall	ResetLCD
	Mov	DPTR,#PesanNomorUser		;Display 'NO USER '
	Lcall	KirimPesan_LCD			;

	Lcall	Get2BKeypad			;
	Mov	UserID,A
	Lcall	Get2BKeypad
	Mov	UserID+1,A
TungguKartu:
	Lcall	TulisKartu
	Jc	TungguKartu
	Lcall	Baris2_LCD
	Mov	DPTR,#PesanVerifikasi		;Display 'VERIFIKASI'
	Lcall	KirimPesan_LCD			;
	Lcall	BacaKartu			;
	Mov	A,Buffer+6			;
	Lcall	LCDOut				;
	Mov	A,Buffer+7			;
	Lcall	LCDOut				;

TungguEnter2:
	Lcall	KeypadLepas
	Lcall	KeypadPolling
	Lcall	KeypadASCII
	Cjne	A,#'#',TungguEnter2
	Lcall	ResetLCD
	Ljmp	Loop


DisplayData:
	Lcall	ResetLCD

	Mov	DPTR,#PesanRecordNumber		;Display 'RECORD NO:'
	Lcall	KirimPesan_LCD			;
	Lcall	KeypadLepas			;Tulis Nomor Record
	Lcall	KeypadPolling			;dan display di LCD
	Lcall	KeypadASCII			;
	Cjne	A,#'*',NoExit
	Lcall	ResetLCD
	Ljmp	Loop

NoExit:	
	Push	B				;
	Lcall	Kirim_Karakter			;
	Pop	A				;
	Mov	B,#100				;
	Mul	AB				;
	Push	A				;
	

	Lcall	KeypadLepas			;
	Lcall	KeypadPolling			;
	Lcall	KeypadASCII			;
	Cjne	A,#'*',NoExit2
	Pop	A
	Lcall	ResetLCD
	Ljmp	Loop

NoExit2:	

	Push	B				;
	Lcall	Kirim_Karakter			;
	Pop	A				;
	Mov	B,#10				;
	Mul	AB				;
	Push	A				;


	Lcall	KeypadLepas			;
	Lcall	KeypadPolling			;
	Lcall	KeypadASCII			;
	Cjne	A,#'*',NoExit3
	Pop	A
	Pop	A

	Lcall	ResetLCD
	Ljmp	Loop

NoExit3:	


	Push	B				;
	Lcall	Kirim_Karakter			;
	Pop	A				;
	Pop	B				;
	Add	A,B				;
	Pop	B				;
	Add	A,B				;
	Mov	PointerRecord,A			;

LoopDisplayData:
	Lcall	ResetLCD

	Mov	DPTR,#RecordData		;Tunjuk data sesuai no record
	Mov	R7,PointerRecord		;
	Lcall	TunjukRecord			;

	Push	DPH
	Push	DPL
	Mov	DPTR,#PesanUser			;Display 'USER: '
	Lcall	KirimPesan_LCD			;
	Pop	DPL
	Pop	DPH

	
	Lcall	DPTRSEE8bit			;Display nomor ID
	Inc	DPTR				;
	Lcall	LCDOut				;
	Lcall	DPTRSEE8bit			;
	Inc	DPTR				;
	Lcall	LCDOut				;

	Mov	A,#08Dh
	Lcall	Kirim_Perintah
	Mov	A,PointerRecord
	Mov	B,#100
	Div	AB
	Push	B
	Add	A,#30h	
	Lcall	Kirim_Karakter
	Pop	A
	Mov	B,#10
	Div	AB
	Push	B
	Add	A,#30h
	Lcall	Kirim_Karakter

	Pop	A
	Add	A,#30h
	Lcall	Kirim_Karakter


	Lcall	Baris2_LCD			;Display Detik
	Mov	A,#0C6H				;
	Lcall	Kirim_Perintah			;
	Mov	A,#':'				;
	Lcall	Kirim_Karakter			;

	Lcall	DPTRSEE8bit			;
	Inc	DPTR				;
	Lcall	LCDOut				;

	Mov	A,#0C3h				;Display menit
	Lcall	Kirim_Perintah			;
	Mov	A,#':'				;
	Lcall	Kirim_Karakter			;
	Lcall	DPTRSEE8bit			;
	Inc	DPTR				;
	Lcall	LCDOut				;

	Mov	A,#0C1h				;Display jam
	Lcall	Kirim_Perintah			;
	Lcall	DPTRSEE8bit			;
	Inc	DPTR				;	
	Lcall	LCDOut				;

	Mov	A,#0CAh				;Display tanggal
	Lcall	Kirim_Perintah			;
	Lcall	DPTRSEE8bit			;
	Lcall	LCDOut
	Inc	DPTR
	Mov	A,#'/'
	Lcall	Kirim_Karakter

	Mov	A,#0CDh				;Display bulan
	Lcall	Kirim_Perintah			;
	Lcall	DPTRSEE8bit
	Lcall	LCDOut

TungguEnter:
	Lcall	KeypadLepas			;
	Lcall	KeypadPolling			;
	Lcall	KeypadASCII			;
	Cjne	A,#'#',CekUpDown
	Ljmp	DisplayData


CekUpDown:
	Cjne	A,#'C',CekDown
	Dec	PointerRecord
	Ljmp	LoopDisplayData

CekDown:
	Cjne	A,#'D',TungguEnter
	Inc	PointerRecord
	Ljmp	LoopDisplayData


PesanRecordNumber:
	DB	'RECORD NO: ',0FH

PesanUser:
	DB	' USER: ',0FH


KirimDataKartu:
	Lcall	ResetLCD
	Mov	DPTR,#PesanKirimData
	Lcall	KirimPesan_LCD
	Lcall	ReloadCounterRecord

	Mov	DPTR,#RecordData

LoopKirimRecord:
	Lcall	KirimRecord
	Lcall	DecCounterRecord
	Mov	A,RAMCounterRecord
	Jnz	LoopKirimRecord
	Mov	A,RAMCounterRecord+1
	Jnz	LoopKirimRecord
	Lcall	Delay_1detik
	Lcall	ResetLCD
	Ljmp	Loop


PesanKirimData:
	DB	'KIRIM DATA',0Fh


LoopTunjukRecord:
	Lcall	AddDPTR8

TunjukRecord:
	Djnz	R7,LoopTunjukRecord
	Ret

Get2BKeypad:
	Lcall	KeypadLepas			;Ambil byte 3
	Lcall	KeypadPolling			;
	Lcall	KeypadASCII			;

	Push	B
	Lcall	Kirim_Karakter			;

	Lcall	KeypadLepas			;Ambil byte 2
	Lcall	KeypadPolling			;
	Lcall	KeypadASCII			;
	Push	B
	Lcall	Kirim_Karakter	

	Pop	B
	Pop	A
	Swap	A
	Add	A,B
	Ret


AddDPTR8:
	Clr	C
	Mov	A,#8
	Add	A,DPL
	Mov	DPL,A
	Jnc	NoINCDPH
	Inc	DPH
NoINCDPH:
	Ret
		


PesanOK:
	DB	' OK',0Fh

PesanTerlambat
	DB	' TERLAMBAT',0FH


TulisKartu:
	Lcall	CekKartu
	Jc	TidakTulisKartu
	Lcall	TulisData	
	Clr	C
	Ret

TidakTulisKartu:
	Ret
	


BacaKartu:
	Lcall	CekKartu
	Jc	TidakAdaKartu
	Lcall	BacaData	
	Clr	C
	Ret

TidakAdaKartu:
	Ret


;===============================================================
; RUTIN RESET LCD

ResetLCD:
	Lcall	ClearLCD
	Lcall	Baris1_LCD
	Ret


;===============================================================
; RUTIN PENGAMBILAN DATA KEYPAD

AmbilDataKeypad:
	Push	07
	Lcall	Ambil_Keypad
	Jc	NoKeypad
	Lcall	KeypadASCII

NoKeypad:
	Pop	07
	Ret


;===================================================================
; Periksa Kartu
; - Proses Request Tipe
; - Request Serial Number bila kartu available
; - Pilih kartu
; - Proses Autentikasi
; - Bila kartu tidak ada maka set Carry dan return

CekKartu:
	Mov	DPTR,#PesanReqType	;Request tipe kartu
	Mov	R7,#6			;
	Mov	R6,#0			;
	Lcall	KirimSerial		;
	Lcall	AmbilRespon		;


	Mov	A,Buffer+5		;Cek Ada kartu tidak
	Jz	AdaKartu
	Lcall	Delay_1detik
	Setb	C
	Ret

AdaKartu:
	Mov	A,Buffer+6		;Ambil tipe kartu
	Mov	Buffer,A		;Simpan di buffer


;===== REQUEST SERIAL NUMBER

	Mov	DPTR,#PesanReqSerial	;
	Mov	R7,#6			;
	Mov	R6,#0			;
	Lcall	KirimSerial		;
	Lcall	AmbilRespon		;

	Mov	R0,#Buffer+6
	Mov	R1,#Buffer
	Mov	R7,#4
	Lcall	CopyBuffer

	Mov	DPTR,#PesanPilihKartu
	Mov	R7,#9
	Mov	R6,#0
	Lcall	KirimSerial
	Lcall	AmbilRespon


;===== AUTENTIKASI 2
; KEY A = 60h
; KEY B = 61h
;
Halaman		EQU	1


	Mov	R0,#Buffer
	Mov	@R0,#60h		;Key A
	Inc	R0
	Mov	@R0,#Halaman
	Inc	R0
	Mov	R7,#6

LoopAutentikasi2:
	Mov	@R0,#0FFh
	Inc	R0
	Djnz	R7,LoopAutentikasi2

	Mov	DPTR,#PesanAutentikasi
	Mov	R7,#13
	Mov	R6,#0
	Lcall	KirimSerial
	Lcall	AmbilRespon
	Clr	C
	Ret




;===== PROSES TULIS KARTU
TulisData:
	Mov	R0,#Buffer
	Mov	@R0,#Halaman
	Inc	R0

	Mov	@R0,UserID
	Inc	R0
	Mov	@R0,UserID+1
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0
	Mov	@R0,#00
	Inc	R0

	Mov	R7,#16h
	Mov	R6,#0
	Mov	DPTR,#PesanTulisData
	Lcall	KirimSerial
	Lcall	AmbilRespon
	Ret	

;===== PROSES BACA KARTU


BacaData:
	Mov	R7,#06
	Mov	R6,#0
	Mov	Buffer,#Halaman
	Mov	DPTR,#PesanBacaData
	Lcall	KirimSerial
	Lcall	AmbilRespon
	Ret


PesanWriting:
	DB	'Writing',0Fh


CopyBuffer:
	Mov	A,@R0
	Mov	@R1,A
	Inc	R0
	Inc	R1
	Djnz	R7,CopyBuffer
	Ret

AmbilRespon:
	Lcall	Serial_In
	Cjne	A,#0AAh,AmbilRespon
	Lcall	Serial_In
	Cjne	A,#0BBh,AmbilRespon
	Lcall	Serial_In
	Mov	R7,A
	Lcall	Serial_In
	Mov	R6,A
	Mov	R0,#Buffer
	Dec	R7
	Mov	@R0,07
	Inc	R0

LoopSerialIn:
	Lcall	Serial_In
	Mov	@R0,A
	Inc	R0
	Djnz	R7,LoopSerialIn	
	Lcall	Serial_In
	Ret	


KirimFixData:
	Mov	A,#0AAh
	Lcall	Serial_Out
	Mov	A,#0BBh
	Lcall	Serial_Out
	Mov	A,R7
	Lcall	Serial_Out
	Mov	A,R6
	Lcall	Serial_Out
	Mov	Temp,#00

	Mov	A,#00
	Movc	A,@A+DPTR
	Mov	R5,A
	Inc	DPTR

LoopSerial:
	Mov	A,#00
	Movc	A,@A+DPTR
	Inc	DPTR
	Lcall	Serial_Out
	Xrl	A,Temp
	Mov	Temp,A
	Dec	R7
	Djnz	R5,LoopSerial

	Ret	





KirimSerial:
	Lcall	KirimFixData
	Dec	R7
	Mov	A,R7			;Masih ada data?
	Jz	TidakAdaDataLagi
	Mov	R0,#Buffer

LoopDataTambahan:
	Mov	A,@R0
	Lcall	Serial_Out
	Xrl	A,Temp
	Mov	Temp,A
	Inc	R0
	Djnz	R7,LoopDataTambahan


TidakAdaDataLagi:
	Mov	A,Temp
	Lcall	Serial_Out
	Ret


InitReader:
;===== SET BAUDRATE

	Mov	DPTR,#PesanBaudrate	;set baudrate 19200
	Mov	R7,#6			;
	Mov	R6,#0			;
	Lcall	KirimSerial		;
	Lcall	AmbilRespon		;
	Ret

DisplayWaktu:
	Lcall	DisplayJam

	Mov	A,#0C3h
	Lcall	Kirim_Perintah
	Lcall	DisplayTanggal
	Ret	

DisplayJam:
	Mov	R0,#BufferDS1307+2
	Mov	A,@R0
	Lcall	LCDOut
	Mov	A,#':'
	Lcall	Kirim_Karakter
	Dec	R0
	Mov	A,@R0
	Lcall	LCDOut
	Mov	A,#':'
	Lcall	Kirim_karakter
	Dec	R0
	Mov	A,@R0
	Lcall	LCDOut
	Ret

DisplayTanggal:
	Mov	R0,#BufferDS1307+4
	Mov	A,@R0
	Lcall	LCDOut
	Mov	A,#'/'
	Lcall	Kirim_Karakter
	Inc	R0
	Mov	A,@R0
	Lcall	LCDOut
	Mov	A,#'/'
	Lcall	Kirim_karakter
	Inc	R0
	Mov	A,@R0
	Lcall	LCDOut
	Ret


LCDOut:
	Lcall	Hex_ASCII2
	Push	B
	Lcall	Kirim_Karakter
	Pop	B
	Xch	A,B
	Lcall	Kirim_Karakter
	Ret



PesanFormatRecord:
	DB	'FORMAT RECORD',0Fh	

HapusRecord:
	Lcall	Init_LCD
	Mov	DPTR,#PesanFormatRecord
	Lcall	KirimPesan_LCD

	Mov	DPTR,#RecordData

	Mov	R6,#60
Loop2HapusRecord:
	Mov	R7,#20*8
LoopHapusRecord:
	Mov	DataI2C,#00
	Push	07
	Push	06
	Lcall	TulisDPTRSEE8b
	Pop	06
	Pop	07	
	Inc	DPTR
	Djnz	R7,LoopHapusRecord
	Lcall	Baris2_LCD
	Mov	A,R6
	Push	06
	Mov	R0,#TabelDesimal
	Lcall	Konversi1BDesimal
	Pop	06

	Mov	A,TabelDesimal+1
	Add	A,#30h
	Lcall	Kirim_Karakter
	Mov	A,TabelDesimal
	Add	A,#30H
	Lcall	Kirim_Karakter

	Djnz	R6,Loop2HapusRecord

	Mov	DPTR,#CounterRecord		;
	Mov	DataI2C,#0			;Hapus Counter Record
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR
	Mov	DataI2C,#0			;
	Lcall	TulisDPTRSEE8b			;

	Mov	DPTR,#RecordData		;Reset pointer alamat record
	Push	DPH				;
	Push	DPL				;
	
	Mov	DPTR,#AlamatRecord		;	
	Pop	DataI2C				;
	Lcall	TulisDPTRSEE8b			;
	Inc	DPTR				;
	Pop	DataI2C				;
	Lcall	TulisDPTRSEE8b			;

	Ret


ReloadCounterRecord:
	Mov	DPTR,#CounterRecord		;Reload Counter Record
	Lcall	DPTRSEE8bit			;
	Mov	RAMCounterRecord,A		;
	Inc	DPTR				;
	Lcall	DPTRSEE8bit
	Mov	RAMCounterRecord+1,A		;
	Ret

DecCounterRecord:
	Dec	RAMCounterRecord
	Mov	A,RAMCounterRecord
	Cjne	A,#0FFh,TidakDec2
	Dec	RAMCounterRecord+1
TidakDec2:
	Ret

KirimRecord:
	Mov	R7,#8
LoopKirimRec:
	Push	07
	Lcall	DPTRSEE8bit
	Pop	07
	Inc	DPTR
	Lcall	Serial_Out
	Djnz	R7,LoopKirimRec
	Ret



	include	out
	include	ascii_he
	include	hexascii
	include	delay_1d
	include	lcd
	include	see
	include	ds1307
	include	hexdec1b
	include	key44
	include	cariprnt

PesanBaudrate:
	DB	05,00,00,01,01,03

PesanReqType:
	DB	05,00,00,01,02,52h

PesanReqSerial:
	DB	04,00,00,02,02

PesanPilihKartu:
	DB	04,00,00,03,02

PesanAutentikasi:
	DB	04,00,00,07,02

PesanBacaData:
	DB	04,00,00,08,02

PesanTulisData:
	DB	04,00,00,09,02



KapasitasRecord	EQU	8		; 2 byte ID, 6 byte Detik, Menit, Jam, Tanggal, Bulan, Tahun

	.DATA
	Org	00
Default		Ds	1
CounterRecord	Ds	2
AlamatRecord	Ds	2
RecordData	Ds	20*8*7