;****************************************************************************
; SUBROUTINE MENULIS DAN MEMBACA DATA SERIAL RTC V2.1
; Revisi: 27/10/07
; - Metode pembacaan dilakukan secara sequential
; - Pembacaan data secara random dihapus
; - Disediakan 7 byte buffer untuk buffer DS1307

	.DATA
	Org	$
BufferDS1307	Ds	7

RegSecond	EQU	00
RegMinute	EQU	01
RegHour		EQU	02
RegDay		EQU	03
RegDate		EQU	04
RegMonth	EQU	05
RegYear		EQU	06
	
	.CODE
	Org	$

CopyWaktu:
	Mov	R0,#BufferDS1307
	Mov	B,#00
	Mov	R7,#0D0H
	Mov	R6,#07

LoopCopyWaktu:
	Mov	DataI2C,@R0
	Push	07
	Push	B
	Lcall	Tulis_SEE8b
	Pop	B
	Pop	07
	Inc	B
	Inc	R0
	Djnz	R6,LoopcopyWaktu
	Ret

AmbilDataDS1307:
	Lcall	Buat_StartBit			;Siapkan register alamat
	Mov	A,#0D0H				;
	Lcall	KirimDataI2C			;
	Mov	A,#00H				;
	Lcall	KirimDataI2C			;
	Lcall	Buat_StopBit			;

	
	Mov	R0,#BufferDS1307		;Start to Read
	Lcall	Buat_StartBit			;
	Mov	A,#0D1H				;
	Lcall	KirimDataI2C			;

	Mov	R7,#7				;Baca data DS1307 secara sequential
LoopBacaDS1307:					;
	Lcall	BacaDataI2C			;	
	Mov	@R0,A				;
	Inc	R0				;
	Clr	SDA				;
	Setb	SCL
	Clr	SCL
;	Lcall	PulseI2C			;
;	Setb	SDA				;
	Djnz	R7,LoopBacaDS1307		;
	Lcall	Buat_StopBit			;
	Ret



;**********************************
; INISIALISASI RTC DS1307
; | OUT | 0 | 0 | SQWE| 0 | 0 | RS1| RS0|
; - Saat SQWE = 0 maka output RTC = OUT
; - SQWE = Square Enable
; - RS1 & RS0, 00 = 1 Hz, 01 = 4096, 10 = 8192, 11 = 32768

TurnONDS1307:
	Mov	DataI2C,#90H
	Mov	R7,#0D0H
	Mov	B,#07
	Lcall	Tulis_See8b
	Ret