;****************************************************************************
; SUBROUTINE MENULIS DAN MEMBACA DATA SERIAL EEPROM V2.0
; Revisi: 26/09/07
; - Baca dan Tulis Serial EEPROM dengan pengalamatan 8 bit dan 16 bit
; - Penulisan data Serial EEPROM secara Paging 32 byte dengan pengalamatan 8 bit
;   dan 16 bit

	.DATA
Slave_AddrSEE	Ds	1
DataI2C	Ds	1
SDA	Bit	P2.0
SCL	Bit	P2.1

	.Code


Wrong_Write:
	Lcall	Buat_StopBit
	Clr	C
NotValid:
	Ret

***********
; SUBROUTINE TULIS SERIAL EEPROM 8 BIT
; - R7 = Device Address = A0h
; - B = Word Address
; - DataI2C = Data yang ditulis
; Hasil:
; - Carry Flag Set bila No ACK
; - F0 set bila terjadi arbitrasi

Tulis_SEE8b:
	Lcall	Siapkan8bAlamatSEE
	Jc	Wrong_Write
	Jb	F0,NotValid
	Mov	A,DataI2C		
	Lcall	KirimDataI2C
	Jc	Wrong_Write
	Jb	F0,NotValid
	Lcall	Buat_StopBit
	Lcall	DelaySEE
	Ret



***********
; SUBROUTINE BACA EEPROM 8 BIT
; - R7 = Device Address = A0h
; - B = Word Address 1
; Hasil:
; - Carry Flag Set bila No ACK
; - F0 set bila terjadi arbitrasi
; - Data yang dibaca di A

Baca_SEE8b:
	Clr	C
	Lcall	Siapkan8bAlamatSEE
	Jc	Wrong_Read
	Jb	F0,NoRead
	Lcall	Buat_StartBit		;Kirim Device Address dengan
	Lcall	ModeBacaSEE
	Jc	Wrong_read
	Jb	F0,NoRead
	Lcall	BacaDataI2C
	Lcall	Ambil_ACK
	Ret


Wrong_Read:
	Lcall	Buat_StopBit
	Clr	C
NoRead:
	Ret




KirimDeviceAddress:
	Lcall	Buat_StartBit
	Push	A
	Mov	A,R7			;Device Address
	Lcall	KirimDataI2C		;
	Pop	A			;
	Ret

Kirim1WordAddress:
	Push	A			;
	Mov	A,B			;First Word Address
	Lcall	KirimDataI2C		;
	Pop	A			;
	Ret

Kirim2WordAddress:
	Push	A
	Mov	A,R6			;Second Address
	Lcall	KirimDataI2C		;
	Pop	A
	Ret



SalahTulisAlamat:
	Ret

Siapkan8bAlamatSEE:
	Lcall	KirimDeviceAddress
	Jc	SalahTulisAlamat		
	Jb	F0,SalahTulisAlamat
	Lcall	Kirim1WordAddress
	Ljmp	SalahTulisAlamat

ModeBacaSEE:
	Push	A			;
	Mov	A,R7
	Setb	A.0
	Mov	Slave_AddrSEE,A
	Pop	A
	Mov	A,Slave_AddrSEE
	Lcall	KirimDataI2C
	Ret

DPHSEE8bit:
	Mov	R7,#0A0H
	MOv	A,DPH
	Anl	A,#00000011b		;Ambil bit 0 dan 1 DPH
	Rl	A			;Geser kiri 1x

	Orl	A,R7			;Copy bit 1 dan 2 ke R7
	Mov	R7,A			;
	Mov	B,DPL		
	Ret

DPTRSEE8bit:
	Lcall	DPHSEE8bit
	Lcall	Baca_SEE8b
	Lcall	DelaySEE
	Ret


TulisDPTRSEE8b:
	Lcall	DPHSEE8bit
	Lcall	Tulis_SEE8b
	Lcall	DelaySEE
	Ret


DelaySEE:
	Push	B
	Mov	B,#6
LoopDelaySEE:
	Push	B
	Mov	B,#00
	Djnz	B,$
	Pop	B
	Djnz	B,LoopDelaySEE
	Pop	B
	Ret

;****************************************************************************
; I2C SUBROUTINES AS MASTER
;
; Baca Data I2C
; - Subroutine untuk membaca data dari I2C
; - Hasil tersimpan di A
; - Bila Carry Flag set, maka proses pembacaan No ACK

BacaDataI2C:
	Push	B
	Mov	B,#08H
	Clr	A
LoopBacaSEE16b:
	Push	B
	Rl	A
	Setb	SDA
	Setb	SCL
	Clr	C
	Mov	C,SDA
	Mov	A.0,C
	Clr	SCL
	Pop	B
	Djnz	B,LoopBacaSEE16b
;	Lcall	Ambil_Ack
;	Lcall	Buat_StopBit
	Pop	B
	Ret

;********************
;Kirim Data I2C
; - Subroutine menulis data I2C 
; - Data yang ditulis di A
; - F0 set bila terjadi kondisi arbitrasi
; - Carry Flag set bila terjadi No ACK

KirimDataI2C:
	Clr	F0
	Push	B
	Mov	B,#8
Send8_bitloop
	Rlc	A
	Mov	SDA,C
	Jnc	Tidak1
	Jb	SDA,TidakError
	Setb	F0

TidakError:
Tidak1:
	Lcall	PulseI2C
	Djnz	B,Send8_bitloop
	Pop	B
	Clr	C
	Lcall	Ambil_Ack
	Ret

;************************
; PULSE I2C
; - Subroutine memberikan sinyal clock di komponen I2C
; - Signal clock akan disinkronkan dengan master lain yang mengakses bus ini
;   dengan menunggu kondisi SCL logika 1

PulseI2C:
	Push	B
	Setb	SCL
	Jnb	SCL,$
	Clr	SCL
	Pop	B
	Ret


Buat_StartBit:
	Setb	SDA
	Setb	SCL
	Jnb	SDA,$			;Tunggu jalur free
	Jnb	SCL,$			;
	Clr	SDA			;Start data
	Clr	SCL			;
	Ret

Buat_StopBit:
	Clr	SDA
	Setb	SCL
	Setb	SDA
	Clr	SCL
	Ret

Ambil_Ack:
	Clr	C
	Setb	SDA
	Setb	SCL
	Mov	C,SDA
	Clr	SCL
;	Jnb	SDA,$
	Ret
